@echo off
title Rental Mobil Windows Deployment
color 0A

echo.
echo ====================================
echo    RENTAL MOBIL DEPLOYMENT
echo ====================================
echo.

:: Check if running in correct directory
if not exist "package.json" (
    echo [ERROR] Please run this script in the project root directory
    echo [ERROR] package.json not found
    pause
    exit /b 1
)

echo [✓] Found package.json
echo [1] Checking prerequisites...

:: Check Git
git --version >nul 2>&1
if %errorlevel% neq 0 (
    echo [❌] Git not found
    echo [INFO] Downloading Git...
    powershell -Command "iwr -useb https://git-scm.com/download/win -OutFile git-installer.exe"
    echo [INFO] Installing Git...
    start /wait git-installer.exe
    echo [✓] Git installed
) else (
    echo [✓] Git found: 
    git --version
)

:: Check Node.js
node --version >nul 2>&1
if %errorlevel% neq 0 (
    echo [❌] Node.js not found
    echo [INFO] Downloading Node.js...
    powershell -Command "iwr -useb https://nodejs.org/dist/v18.19.0/node-v18.19.0-x64.msi -OutFile node-installer.msi"
    echo [INFO] Installing Node.js...
    start /wait node-installer.msi
    echo [✓] Node.js installed
) else (
    echo [✓] Node.js found:
    node --version
)

:: Check Vercel CLI
vercel --version >nul 2>&1
if %errorlevel% neq 0 (
    echo [❌] Vercel CLI not found
    echo [INFO] Installing Vercel CLI...
    npm install -g vercel
    if %errorlevel% neq 0 (
        echo [❌] Failed to install Vercel CLI
        pause
        exit /b 1
    )
    echo [✓] Vercel CLI installed
) else (
    echo [✓] Vercel CLI found:
    vercel --version
)

echo.
echo [2] Setting up environment...
if not exist ".env.local" (
    echo [INFO] Creating .env.local file...
    (
        echo DATABASE_URL=file:./db/prod.db
        echo NEXTAUTH_SECRET=your-super-secret-key-change-this-in-production
        echo NEXTAUTH_URL=https://yourdomain.com
        echo NODE_ENV=production
    ) > .env.local
    echo [✓] .env.local created
    echo [WARNING] Please edit .env.local with your actual values!
) else (
    echo [✓] .env.local exists
)

echo.
echo [3] Installing dependencies...
npm ci >nul 2>&1
if %errorlevel% neq 0 (
    echo [❌] Failed to install dependencies
    echo [INFO] Trying with npm install...
    npm install
    if %errorlevel% neq 0 (
        echo [❌] Failed to install dependencies
        pause
        exit /b 1
    )
)
echo [✓] Dependencies installed

echo.
echo [4] Building project...
npm run build >nul 2>&1
if %errorlevel% neq 0 (
    echo [❌] Build failed
    pause
    exit /b 1
)
echo [✓] Build completed

echo.
echo [5] Vercel Deployment Options:
echo [1] Deploy via Vercel Dashboard (Recommended)
echo [2] Deploy via Vercel CLI
echo [3] Open Vercel Dashboard
echo.

set /p choice=Please choose deployment method: 

if "%choice%"=="1" (
    echo [INFO] Opening Vercel Dashboard...
    start https://vercel.com/dashboard
    echo [✓] Please follow the browser deployment guide
) else if "%choice%"=="2" (
    echo [INFO] Deploying via Vercel CLI...
    vercel --prod
    if %errorlevel% neq 0 (
        echo [❌] Deployment failed
        pause
        exit /b 1
    )
    echo [✓] Deployment completed!
) else if "%choice%"=="3" (
    echo [INFO] Opening Vercel Dashboard...
    start https://vercel.com/new
    echo [✓] Please import your repository first
) else (
    echo [INFO] Opening Vercel Dashboard for setup...
    start https://vercel.com
)

echo.
echo ====================================
echo    DEPLOYMENT PROCESS
echo ====================================
echo.
echo Next steps:
echo 1. Configure custom domain in Vercel dashboard
echo 2. Set up environment variables
echo 3. Configure DNS settings
echo 4. Test website functionality
echo.
echo Documentation: BROWSER_DEPLOY_GUIDE.md
echo.
pause